var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import PropTypes from 'prop-types';
import requiredIf from 'react-required-if';
import ReactCursorPosition from 'react-cursor-position';
import objectAssign from 'object-assign';

import ImageLensShaded from './ImageLensShaded';
import EnlargedImage from './EnlargedImage';
import ImageShape from './ImageShape';
import noop from './noop';

var ReactImageMagnify = function (_React$Component) {
    _inherits(ReactImageMagnify, _React$Component);

    function ReactImageMagnify(props) {
        _classCallCheck(this, ReactImageMagnify);

        var _this = _possibleConstructorReturn(this, (ReactImageMagnify.__proto__ || Object.getPrototypeOf(ReactImageMagnify)).call(this, props));

        _this.state = {
            smallImageWidth: 0,
            smallImageHeight: 0,
            detectedEnvironment: {
                isMouseDeteced: false,
                isTouchDetected: false
            },
            isActive: false
        };

        _this.onSmallImageLoad = _this.onSmallImageLoad.bind(_this);
        _this.setSmallImageDimensionState = _this.setSmallImageDimensionState.bind(_this);
        _this.onDetectedEnvironmentChanged = _this.onDetectedEnvironmentChanged.bind(_this);
        _this.onActivationChanged = _this.onActivationChanged.bind(_this);
        return _this;
    }

    _createClass(ReactImageMagnify, [{
        key: 'onSmallImageLoad',
        value: function onSmallImageLoad(e) {
            var _props$smallImage$onL = this.props.smallImage.onLoad,
                onLoad = _props$smallImage$onL === undefined ? noop : _props$smallImage$onL;


            onLoad(e);

            if (!this.props.smallImage.isFluidWidth) {
                return;
            }

            this.setSmallImageDimensionState();
        }
    }, {
        key: 'setSmallImageDimensionState',
        value: function setSmallImageDimensionState() {
            var _smallImageEl = this.smallImageEl,
                smallImageWidth = _smallImageEl.offsetWidth,
                smallImageHeight = _smallImageEl.offsetHeight;


            this.setState({
                smallImageWidth: smallImageWidth,
                smallImageHeight: smallImageHeight
            });
        }
    }, {
        key: 'onDetectedEnvironmentChanged',
        value: function onDetectedEnvironmentChanged(detectedEnvironment) {
            this.setState({
                detectedEnvironment: detectedEnvironment
            });
        }
    }, {
        key: 'onActivationChanged',
        value: function onActivationChanged(_ref) {
            var isActive = _ref.isActive;

            this.setState({
                isActive: isActive
            });
        }
    }, {
        key: 'getEnlargedImagePlacement',
        value: function getEnlargedImagePlacement() {
            var enlargedImagePosition = this.props.enlargedImagePosition;
            var isTouchDetected = this.state.detectedEnvironment.isTouchDetected;


            return enlargedImagePosition || (isTouchDetected ? 'over' : 'beside');
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            if (this.props.smallImage.isFluidWidth) {
                this.setSmallImageDimensionState();
                window.addEventListener('resize', this.setSmallImageDimensionState);
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            window.removeEventListener('resize', this.setSmallImageDimensionState);
        }
    }, {
        key: 'getCursorOffsetDimension',
        value: function getCursorOffsetDimension(smallImageDimension, largeImageDimension) {
            return Math.round(smallImageDimension / largeImageDimension * smallImageDimension / 2);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                className = _props.className,
                enlargedImageContainerClassName = _props.enlargedImageContainerClassName,
                enlargedImageContainerStyle = _props.enlargedImageContainerStyle,
                enlargedImageClassName = _props.enlargedImageClassName,
                enlargedImageStyle = _props.enlargedImageStyle,
                fadeDurationInMs = _props.fadeDurationInMs,
                hoverDelayInMs = _props.hoverDelayInMs,
                hoverOffDelayInMs = _props.hoverOffDelayInMs,
                isActivatedOnTouch = _props.isActivatedOnTouch,
                imageClassName = _props.imageClassName,
                imageStyle = _props.imageStyle,
                largeImage = _props.largeImage,
                lensStyle = _props.lensStyle,
                pressDuration = _props.pressDuration,
                pressMoveThreshold = _props.pressMoveThreshold,
                isSmallImageFluidWidth = _props.smallImage.isFluidWidth,
                style = _props.style;
            var _state = this.state,
                smallImageWidth = _state.smallImageWidth,
                smallImageHeight = _state.smallImageHeight,
                isTouchDetected = _state.detectedEnvironment.isTouchDetected;


            var fluidWidthSmallImage = objectAssign({}, this.props.smallImage, {
                width: smallImageWidth,
                height: smallImageHeight
            });
            var fixedWidthSmallImage = this.props.smallImage;
            var smallImage = isSmallImageFluidWidth ? fluidWidthSmallImage : fixedWidthSmallImage;

            var cursorOffset = {
                x: this.getCursorOffsetDimension(smallImage.width, largeImage.width),
                y: this.getCursorOffsetDimension(smallImage.height, largeImage.height)
            };

            var fluidWidthContainerStyle = {
                width: 'auto',
                height: 'auto',
                fontSize: '0px',
                position: 'relative'
            };
            var fixedWidthContainerStyle = {
                width: smallImage.width + 'px',
                height: smallImage.height + 'px',
                position: 'relative'
            };
            var priorityContainerStyle = isSmallImageFluidWidth ? fluidWidthContainerStyle : fixedWidthContainerStyle;
            var compositContainerStyle = objectAssign({
                cursor: 'crosshair'
            }, style, priorityContainerStyle);

            var fluidWidthSmallImageStyle = {
                width: '100%',
                height: 'auto',
                display: 'block',
                pointerEvents: 'none'
            };
            var fixedWidthSmallImageStyle = {
                width: smallImage.width + 'px',
                height: smallImage.height + 'px',
                pointerEvents: 'none'
            };
            var prioritySmallImageStyle = isSmallImageFluidWidth ? fluidWidthSmallImageStyle : fixedWidthSmallImageStyle;
            var compositSmallImageStyle = objectAssign({}, imageStyle, prioritySmallImageStyle);
            var enlargedImagePlacement = this.getEnlargedImagePlacement();
            var shouldShowLens = enlargedImagePlacement !== 'over' && !isTouchDetected;

            return React.createElement(
                ReactCursorPosition,
                {
                    className: className,
                    hoverDelayInMs: hoverDelayInMs,
                    hoverOffDelayInMs: hoverOffDelayInMs,
                    isActivatedOnTouch: isActivatedOnTouch,
                    onActivationChanged: this.onActivationChanged,
                    onDetectedEnvironmentChanged: this.onDetectedEnvironmentChanged,
                    pressDuration: pressDuration,
                    pressMoveThreshold: pressMoveThreshold,
                    style: compositContainerStyle
                },
                React.createElement('img', {
                    src: smallImage.src,
                    srcSet: smallImage.srcSet,
                    sizes: smallImage.sizes,
                    alt: smallImage.alt,
                    className: imageClassName,
                    style: compositSmallImageStyle,
                    ref: function ref(el) {
                        return _this2.smallImageEl = el;
                    },
                    onLoad: this.onSmallImageLoad
                }),
                shouldShowLens && React.createElement(ImageLensShaded, {
                    cursorOffset: cursorOffset,
                    fadeDurationInMs: fadeDurationInMs,
                    smallImage: smallImage,
                    style: lensStyle
                }),
                React.createElement(EnlargedImage, {
                    containerClassName: enlargedImageContainerClassName,
                    containerStyle: enlargedImageContainerStyle,
                    cursorOffset: cursorOffset,
                    fadeDurationInMs: fadeDurationInMs,
                    imageClassName: enlargedImageClassName,
                    imageStyle: enlargedImageStyle,
                    imagePosition: enlargedImagePlacement,
                    largeImage: largeImage,
                    smallImage: smallImage
                })
            );
        }
    }]);

    return ReactImageMagnify;
}(React.Component);

ReactImageMagnify.propTypes = {
    className: PropTypes.string,
    enlargedImageContainerClassName: PropTypes.string,
    enlargedImageContainerStyle: PropTypes.object,
    enlargedImageClassName: PropTypes.string,
    enlargedImageStyle: PropTypes.object,
    fadeDurationInMs: PropTypes.number,
    hoverDelayInMs: PropTypes.number,
    hoverOffDelayInMs: PropTypes.number,
    isActivatedOnTouch: PropTypes.bool,
    imageClassName: PropTypes.string,
    imageStyle: PropTypes.object,
    largeImage: ImageShape,
    lensStyle: PropTypes.object,
    pressDuration: PropTypes.number,
    pressMoveThreshold: PropTypes.number,
    smallImage: PropTypes.shape({
        alt: PropTypes.string,
        isFluidWidth: PropTypes.bool,
        src: PropTypes.string.isRequired,
        srcSet: PropTypes.string,
        sizes: PropTypes.string,
        width: requiredIf(PropTypes.number, function (props) {
            return !props.isFluidWidth;
        }),
        height: requiredIf(PropTypes.number, function (props) {
            return !props.isFluidWidth;
        }),
        onLoad: PropTypes.func
    }),
    style: PropTypes.object,
    enlargedImagePosition: PropTypes.oneOf(['beside', 'over'])
};
ReactImageMagnify.defaultProps = {
    fadeDurationInMs: 300,
    hoverDelayInMs: 250,
    hoverOffDelayInMs: 150
};


export default ReactImageMagnify;