import React from 'react';
import objectAssign from 'object-assign';
import clamp from 'clamp';
import Lens from './Lens';

var LensBottom = function LensBottom(_ref) {
    var cursorOffset = _ref.cursorOffset,
        position = _ref.position,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        smallImage = _ref.smallImage,
        style = _ref.style;


    var maxHeight = smallImage.height - cursorOffset.y * 2;
    var height = clamp(smallImage.height - position.y - cursorOffset.y, 0, maxHeight);
    var top = Math.max(position.y + cursorOffset.y, cursorOffset.y * 2);
    var computedStyle = {
        height: height + 'px',
        width: '100%',
        top: top
    };

    return React.createElement(Lens, {
        fadeDurationInMs: fadeDurationInMs,
        isActive: isActive,
        isPositionOutside: isPositionOutside,
        style: objectAssign({}, style, computedStyle)
    });
};

export default LensBottom;