import React from 'react';
import objectAssign from 'object-assign';
import LensTop from './LensTop';
import LensLeft from './LensLeft';
import LensRight from './LensRight';
import LensBottom from './LensBottom';

export default function ImageLensShaded(_ref) {
    var cursorOffset = _ref.cursorOffset,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        position = _ref.position,
        smallImage = _ref.smallImage,
        style = _ref.style;

    var compositLensStyle = objectAssign({
        backgroundColor: 'rgba(0,0,0,.4)'
    }, style);

    return React.createElement(
        'div',
        null,
        React.createElement(LensTop, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        React.createElement(LensLeft, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        React.createElement(LensRight, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        React.createElement(LensBottom, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        })
    );
}