var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import objectAssign from 'object-assign';
import PropTypes from 'prop-types';
import clamp from 'clamp';
import ImageShape from './ImageShape';
import Point from './Point';
import noop from './noop';

var _class = function (_React$Component) {
    _inherits(_class, _React$Component);

    function _class(props) {
        _classCallCheck(this, _class);

        var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this, props));

        _this.state = {
            isTransitionEntering: false,
            isTransitionActive: false,
            isTransitionLeaving: false,
            isTransitionDone: false
        };

        _this.timers = [];
        return _this;
    }

    _createClass(_class, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var _this2 = this;

            var _props = this.props,
                fadeDurationInMs = _props.fadeDurationInMs,
                isActive = _props.isActive,
                isPositionOutside = _props.isPositionOutside;


            if (isActive === nextProps.isActive && isPositionOutside === nextProps.isPositionOutside) {
                return;
            }

            if (nextProps.isActive && !nextProps.isPositionOutside) {
                this.setState({
                    isTrainsitionDone: false,
                    isTransitionEntering: true
                });

                this.timers.push(setTimeout(function () {
                    _this2.setState({
                        isTransitionEntering: false,
                        isTransitionActive: true
                    });
                }, 0));
            } else {
                this.setState({
                    isTransitionLeaving: true,
                    isTransitionActive: false
                });

                this.timers.push(setTimeout(function () {
                    _this2.setState({
                        isTransitionDone: true,
                        isTransitionLeaving: false
                    });
                }, fadeDurationInMs));
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this.timers.forEach(function (timerId) {
                clearTimeout(timerId);
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                containerClassName = _props2.containerClassName,
                containerStyle = _props2.containerStyle,
                cursorOffset = _props2.cursorOffset,
                position = _props2.position,
                fadeDurationInMs = _props2.fadeDurationInMs,
                imageClassName = _props2.imageClassName,
                imageStyle = _props2.imageStyle,
                isLazyLoaded = _props2.isLazyLoaded,
                largeImage = _props2.largeImage,
                _props2$largeImage$on = _props2.largeImage.onLoad,
                onLoad = _props2$largeImage$on === undefined ? noop : _props2$largeImage$on,
                smallImage = _props2.smallImage,
                imagePosition = _props2.imagePosition;
            var _state = this.state,
                isTransitionEntering = _state.isTransitionEntering,
                isTransitionActive = _state.isTransitionActive,
                isTransitionLeaving = _state.isTransitionLeaving;


            var offsetRatio = {
                x: largeImage.width / smallImage.width,
                y: largeImage.height / smallImage.height
            };

            var differentiatedImageCoordinates = {
                x: Math.round((position.x - cursorOffset.x) * offsetRatio.x) * -1,
                y: Math.round((position.y - cursorOffset.y) * offsetRatio.y) * -1
            };

            var minCoordinates = {
                x: (largeImage.width - smallImage.width) * -1,
                y: (largeImage.height - smallImage.height) * -1
            };

            var maxCoordinate = 0;

            var imageCoordinates = {
                x: clamp(differentiatedImageCoordinates.x, minCoordinates.x, maxCoordinate),
                y: clamp(differentiatedImageCoordinates.y, minCoordinates.y, maxCoordinate)
            };

            var isVisible = void 0;
            if (isTransitionEntering || isTransitionActive || isTransitionLeaving) {
                isVisible = true;
            } else {
                isVisible = false;
            }

            var defaultContainerStyle = {
                position: 'absolute',
                top: '0px',
                overflow: 'hidden'
            };

            switch (imagePosition) {
                case 'over':
                    defaultContainerStyle = objectAssign({}, defaultContainerStyle, {
                        left: '0px'
                    });
                    break;
                case 'beside':
                default:
                    defaultContainerStyle = objectAssign({}, defaultContainerStyle, {
                        left: '100%',
                        marginLeft: '10px',
                        border: '1px solid #d6d6d6'
                    });
                    break;
            }

            var computedContainerStyle = {
                width: smallImage.width,
                height: smallImage.height,
                opacity: this.state.isTransitionActive ? 1 : 0,
                transition: 'opacity ' + fadeDurationInMs + 'ms ease-in',
                pointerEvents: 'none'
            };

            var translate = 'translate(' + imageCoordinates.x + 'px, ' + imageCoordinates.y + 'px)';

            var computedImageStyle = {
                width: largeImage.width,
                height: largeImage.height,
                transform: translate,
                WebkitTransform: translate,
                msTransform: translate,
                pointerEvents: 'none'
            };

            var component = React.createElement(
                'div',
                {
                    className: containerClassName,
                    style: objectAssign({}, defaultContainerStyle, containerStyle, computedContainerStyle)
                },
                React.createElement('img', {
                    alt: largeImage.alt,
                    className: imageClassName,
                    src: largeImage.src,
                    srcSet: largeImage.srcSet,
                    sizes: largeImage.sizes,
                    style: objectAssign({}, imageStyle, computedImageStyle),
                    onLoad: onLoad
                })
            );

            if (isLazyLoaded) {
                return isVisible ? component : null;
            }

            return component;
        }
    }]);

    return _class;
}(React.Component);

_class.displayName = 'EnlargedImage';
_class.defaultProps = {
    fadeDurationInMs: 0,
    isLazyLoaded: true
};
_class.propTypes = {
    containerClassName: PropTypes.string,
    containerStyle: PropTypes.object,
    cursorOffset: Point,
    position: Point,
    fadeDurationInMs: PropTypes.number,
    imageClassName: PropTypes.string,
    imageStyle: PropTypes.object,
    isActive: PropTypes.bool,
    isLazyLoaded: PropTypes.bool,
    largeImage: ImageShape,
    smallImage: ImageShape,
    imagePosition: PropTypes.oneOf(['beside', 'over'])
};
export default _class;