'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _clamp = require('clamp');

var _clamp2 = _interopRequireDefault(_clamp);

var _Lens = require('./Lens');

var _Lens2 = _interopRequireDefault(_Lens);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LensRight = function LensRight(_ref) {
    var cursorOffset = _ref.cursorOffset,
        position = _ref.position,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        smallImage = _ref.smallImage,
        style = _ref.style;


    var height = cursorOffset.y * 2;
    var maxHeight = smallImage.height - height;
    var maxWidth = smallImage.width - cursorOffset.x * 2;
    var width = (0, _clamp2.default)(smallImage.width - position.x - cursorOffset.x, 0, maxWidth);
    var translateY = (0, _clamp2.default)(position.y - cursorOffset.y, 0, maxHeight);
    var computedStyle = {
        height: height + 'px',
        width: width + 'px',
        top: '0px',
        right: '0px'
    };

    return _react2.default.createElement(_Lens2.default, {
        fadeDurationInMs: fadeDurationInMs,
        isActive: isActive,
        isPositionOutside: isPositionOutside,
        style: (0, _objectAssign2.default)({}, style, computedStyle),
        translateY: translateY
    });
};

exports.default = LensRight;