'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = ImageLensShaded;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _LensTop = require('./LensTop');

var _LensTop2 = _interopRequireDefault(_LensTop);

var _LensLeft = require('./LensLeft');

var _LensLeft2 = _interopRequireDefault(_LensLeft);

var _LensRight = require('./LensRight');

var _LensRight2 = _interopRequireDefault(_LensRight);

var _LensBottom = require('./LensBottom');

var _LensBottom2 = _interopRequireDefault(_LensBottom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ImageLensShaded(_ref) {
    var cursorOffset = _ref.cursorOffset,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        position = _ref.position,
        smallImage = _ref.smallImage,
        style = _ref.style;

    var compositLensStyle = (0, _objectAssign2.default)({
        backgroundColor: 'rgba(0,0,0,.4)'
    }, style);

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_LensTop2.default, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        _react2.default.createElement(_LensLeft2.default, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        _react2.default.createElement(_LensRight2.default, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        }),
        _react2.default.createElement(_LensBottom2.default, {
            cursorOffset: cursorOffset,
            fadeDurationInMs: fadeDurationInMs,
            isActive: isActive,
            isPositionOutside: isPositionOutside,
            position: position,
            smallImage: smallImage,
            style: compositLensStyle
        })
    );
}